<?php
session_start();
require_once __DIR__ . '/conexao.php';

// 1. Verificação de Permissão de Acesso
if (!isset($_SESSION['usuario']['id']) || $_SESSION['usuario']['perfil'] !== 'SUBDIRECÇÃO PEDAGÓGICA') {
    die('Acesso não autorizado. Apenas a Subdireção Pedagógica pode aceder a este painel.');
}

// 2. Obter o ID da planificação da URL
$id = $_GET['id'] ?? null;
if (!$id) {
    die('ID da planificação não especificado.');
}

// 3. Buscar os dados da planificação
$stmt = $conn->prepare("SELECT * FROM planificacoes_mensais WHERE id = ?");
$stmt->bind_param('i', $id);
$stmt->execute();
$planificacao = $stmt->get_result()->fetch_assoc();

if (!$planificacao) {
    die('Planificação não encontrada.');
}

// 4. Buscar o nome do professor
$stmt_prof = $conn->prepare("SELECT nome FROM usuarios WHERE id = ?");
$stmt_prof->bind_param('i', $planificacao['usuario_id']);
$stmt_prof->execute();
$professor = $stmt_prof->get_result()->fetch_assoc();
$nome_professor = $professor['nome'] ?? 'Desconhecido';
?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Visualizar Planificação</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="style.css">
    <style>
        /* Estilos do formulário original para exibição */
        * { box-sizing: border-box; }
        body { font-family: 'Segoe UI', sans-serif; margin: 0; padding: 0; background: #f5f5f5; color: #222; }
        .page { background: #fff; width: 100%; max-width: 900px; margin: 20px auto; padding: 40px; box-shadow: 0 0 8px rgba(0,0,0,0.1); }
        .header { text-align: center; margin-bottom: 25px; }
        .logo-centro img { display: block; margin: 0 auto; width: 80px; height: auto; }
        .texto-cabecalho { font-weight: bold; line-height: 1.5; margin-top: 10px; }
        h2 { text-align: center; margin-top: 20px; text-transform: uppercase; }
        table { width: 100%; border-collapse: collapse; margin-top: 15px; margin-bottom: 25px; }
        table, td, th { border: 1px solid #333; }
        td { padding: 10px; vertical-align: top; }
        .assinaturas { margin-top: 40px; }
        .semana-titulo { background-color: #eee; font-weight: bold; }
        .obs { text-align: right; font-style: italic; padding-top: 5px; }
        
        /* Oculta inputs e textareas para um visual de visualização mais limpo */
        .page input, .page textarea {
            border: none;
            background-color: transparent;
            width: auto;
            display: inline;
        }
        .page textarea { display: block; width: 100%; }
        .no-border { border: none; }
        .btn-print {
            display: block;
            width: 150px;
            margin: 20px auto;
            padding: 10px;
            background-color: #28a745;
            color: white;
            text-align: center;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
        }

        /* Estilos de impressão */
        @media print {
            body { background: none; }
            .page { box-shadow: none; margin: 0; padding: 20mm; }
            
            /* Esconde o botão de impressão na visualização de impressão */
            .btn-print {
                display: none;
            }
            
            /* Força a Ata a começar numa nova página */
            .page:nth-of-type(2) {
                page-break-before: always;
            }
        }
    </style>
</head>
<body>

<button onclick="window.print()" class="btn-print">Imprimir</button>

<div class="page no-border">
    <div class="header">
        <div class="logo-centro">
            <img src="insignia/insignia.png" alt="Insígnia">
        </div>
        <div class="texto-cabecalho">
            REPÚBLICA DE ANGOLA<br>
            GOVERNO PROVINCIAL DE BENGUELA<br>
            GABINETE PROVINCIAL DA EDUCAÇÃO<br>
            COMPLEXO ESCOLAR BG0026 PADRE EMIL FRICK – CATUMBELA
        </div>
    </div>

    <h2>PLANIFICAÇÃO MENSAL</h2>
    <p>Professor(a): <strong><?= htmlspecialchars($nome_professor) ?></strong></p>

    <table>
        <tr>
            <td>ANO LECTIVO: <?= htmlspecialchars($planificacao['ano_lectivo'] ?? '') ?></td>
            <td>CLASSE: <?= htmlspecialchars($planificacao['classe'] ?? '') ?></td>
            <td>MÊS DE: <?= htmlspecialchars($planificacao['mes'] ?? '') ?></td>
        </tr>
        <tr>
            <td>DISCIPLINA: <?= htmlspecialchars($planificacao['disciplina'] ?? '') ?></td>
            <td>TRIMESTRE: <?= htmlspecialchars($planificacao['trimestre'] ?? '') ?></td>
            <td>DATA: <?= htmlspecialchars($planificacao['data_planificacao'] ?? '') ?></td>
        </tr>
    </table>

    <table>
        <tr class="semana-titulo"><td colspan="2">1ª SEMANA</td></tr>
        <tr>
            <td>De: <?= htmlspecialchars($planificacao['semana1_de'] ?? '') ?></td>
            <td>Até: <?= htmlspecialchars($planificacao['semana1_ate'] ?? '') ?></td>
        </tr>
        <tr>
            <td colspan="2" style="height: 100px;"><?= nl2br(htmlspecialchars($planificacao['semana1_conteudo'] ?? '')) ?></td>
        </tr>
        <tr><td colspan="2" class="obs">Obs: <?= htmlspecialchars($planificacao['semana1_obs'] ?? '') ?></td></tr>
    </table>
    <table>
        <tr class="semana-titulo"><td colspan="2">2ª SEMANA</td></tr>
        <tr>
            <td>De: <?= htmlspecialchars($planificacao['semana2_de'] ?? '') ?></td>
            <td>Até: <?= htmlspecialchars($planificacao['semana2_ate'] ?? '') ?></td>
        </tr>
        <tr>
            <td colspan="2" style="height: 100px;"><?= nl2br(htmlspecialchars($planificacao['semana2_conteudo'] ?? '')) ?></td>
        </tr>
        <tr><td colspan="2" class="obs">Obs: <?= htmlspecialchars($planificacao['semana2_obs'] ?? '') ?></td></tr>
    </table>

    <table>
        <tr class="semana-titulo"><td colspan="2">3ª SEMANA</td></tr>
        <tr>
            <td>De: <?= htmlspecialchars($planificacao['semana3_de'] ?? '') ?></td>
            <td>Até: <?= htmlspecialchars($planificacao['semana3_ate'] ?? '') ?></td>
        </tr>
        <tr>
            <td colspan="2" style="height: 100px;"><?= nl2br(htmlspecialchars($planificacao['semana3_conteudo'] ?? '')) ?></td>
        </tr>
        <tr><td colspan="2" class="obs">Obs: <?= htmlspecialchars($planificacao['semana3_obs'] ?? '') ?></td></tr>
    </table>

    <table>
        <tr class="semana-titulo"><td colspan="2">4ª SEMANA</td></tr>
        <tr>
            <td>De: <?= htmlspecialchars($planificacao['semana4_de'] ?? '') ?></td>
            <td>Até: <?= htmlspecialchars($planificacao['semana4_ate'] ?? '') ?></td>
        </tr>
        <tr>
            <td colspan="2" style="height: 100px;"><?= nl2br(htmlspecialchars($planificacao['semana4_conteudo'] ?? '')) ?></td>
        </tr>
        <tr><td colspan="2" class="obs">Obs: <?= htmlspecialchars($planificacao['semana4_obs'] ?? '') ?></td></tr>
    </table>

    <div class="assinaturas">
        <p>Catumbela, <?= htmlspecialchars($planificacao['data_catumbela'] ?? '') ?></p>
        <strong>Participantes:</strong>
        <p><?= nl2br(htmlspecialchars($planificacao['participantes'] ?? '')) ?></p>
    </div>
</div>

<div class="page no-border">
    <div class="header">
        <div class="logo-centro">
            <img src="insignia/insignia.png" alt="Insígnia">
        </div>
        <div class="texto-cabecalho">
            REPÚBLICA DE ANGOLA<br>
            GOVERNO PROVINCIAL DE BENGUELA<br>
            GABINETE PROVINCIAL DA EDUCAÇÃO<br>
            COMPLEXO ESCOLAR BG0026 PADRE EMIL FRICK – CATUMBELA<br><br>
            SUBDIREÇÃO PEDAGÓGICA
        </div>
    </div>

    <h2>ACTA DA REUNIÃO DE COORDENAÇÃO</h2>

    <p>Acta nº <?= htmlspecialchars($planificacao['acta_numero'] ?? '') ?> da Reunião de Coordenação da Disciplina de <?= htmlspecialchars($planificacao['disciplina'] ?? '') ?>, realizada aos <?= htmlspecialchars($planificacao['acta_data'] ?? '') ?>, sob orientação do(a) Coordenador(a), ladeado(a) pelos seguintes professores:</p>
    <p><?= nl2br(htmlspecialchars($planificacao['acta_participantes'] ?? '')) ?></p>

    <h3>1ª Semana</h3>
    <p>Conteúdo: <?= htmlspecialchars($planificacao['acta_conteudo1'] ?? '') ?></p>
    <p>Objetivos Gerais: <?= htmlspecialchars($planificacao['acta_objetivos_gerais1'] ?? '') ?></p>
    <p>Objetivos Específicos: <?= htmlspecialchars($planificacao['acta_objetivos_especificos1'] ?? '') ?></p>
    <p>Métodos: <?= htmlspecialchars($planificacao['acta_metodos1'] ?? '') ?></p>
    <p>Meios: <?= htmlspecialchars($planificacao['acta_meios1'] ?? '') ?></p>

    <h3>2ª Semana</h3>
    <p>Conteúdo: <?= htmlspecialchars($planificacao['acta_conteudo2'] ?? '') ?></p>
    <p>Objetivos Gerais: <?= htmlspecialchars($planificacao['acta_objetivos_gerais2'] ?? '') ?></p>
    <p>Objetivos Específicos: <?= htmlspecialchars($planificacao['acta_objetivos_especificos2'] ?? '') ?></p>
    <p>Métodos: <?= htmlspecialchars($planificacao['acta_metodos2'] ?? '') ?></p>
    <p>Meios: <?= htmlspecialchars($planificacao['acta_meios2'] ?? '') ?></p>
    
    <h3>3ª Semana</h3>
    <p>Conteúdo: <?= htmlspecialchars($planificacao['acta_conteudo3'] ?? '') ?></p>
    <p>Objetivos Gerais: <?= htmlspecialchars($planificacao['acta_objetivos_gerais3'] ?? '') ?></p>
    <p>Objetivos Específicos: <?= htmlspecialchars($planificacao['acta_objetivos_especificos3'] ?? '') ?></p>
    <p>Métodos: <?= htmlspecialchars($planificacao['acta_metodos3'] ?? '') ?></p>
    <p>Meios: <?= htmlspecialchars($planificacao['acta_meios3'] ?? '') ?></p>
    
    <h3>4ª Semana</h3>
    <p>Conteúdo: <?= htmlspecialchars($planificacao['acta_conteudo4'] ?? '') ?></p>
    <p>Objetivos Gerais: <?= htmlspecialchars($planificacao['acta_objetivos_gerais4'] ?? '') ?></p>
    <p>Objetivos Específicos: <?= htmlspecialchars($planificacao['acta_objetivos_especificos4'] ?? '') ?></p>
    <p>Métodos: <?= htmlspecialchars($planificacao['acta_metodos4'] ?? '') ?></p>
    <p>Meios: <?= htmlspecialchars($planificacao['acta_meios4'] ?? '') ?></p>

    <br><br>
    <p><strong>O(A) Coordenador(a) da Disciplina</strong></p>
    <p><?= htmlspecialchars($planificacao['coordenador'] ?? '') ?></p>
</div>
</body>
</html>